package de.test.webrequest;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.ByteArrayBuffer;
import org.json.JSONArray;
import org.json.JSONException;

import android.os.AsyncTask;
import android.util.Log;

public class SendRequest extends AsyncTask<String, Integer, String> {

	// JSON-Parser
	@Override
	protected String doInBackground(String... uri) {
		HttpClient httpclient = new DefaultHttpClient();
		HttpGet httpget = new HttpGet(uri[0]);
		HttpResponse response;

		try {
			response = httpclient.execute(httpget);
			HttpEntity entity = response.getEntity();

			if (entity != null) {

				InputStream instream = entity.getContent();

				BufferedInputStream bis = new BufferedInputStream(instream);
				ByteArrayBuffer baf = new ByteArrayBuffer(50);

				int current = 0;
				while ((current = bis.read()) != -1) {
					baf.append((byte) current);
				}
				// publishProgress(1);

				// Convert the Bytes read to a String.
				String html = new String(baf.toByteArray());
				
				
				Vector<User> users = new Vector<User>();
				try {
					JSONArray participants = new JSONArray(html);

					int id;
					String name;
					String key;
					User user = new User(0, null, null);
					
					for (int i = 0; i < participants.length(); i++) {
						id = participants.getJSONObject(i).getInt("id");
						name = participants.getJSONObject(i).getString("name")
								.toString();
						key = participants.getJSONObject(i)
								.getString("key").toString();

						user.setId(id);
						user.setName(name);
						user.setKey(key);
						
						users.add(user);
						user = new User(0, null, null);
					}
				} catch (JSONException e) {
					Log.e("test", "There was an error parsing the JSON", e);
				}
				
				String result = "";
				for (int i = 0; i < users.size(); i++) {
					result = result + "ID: " + users.get(i).getId()
							+ ", Name: " + users.get(i).getName() + ", Key: "
							+ users.get(i).getKey() + "\n";
				}
				return result;
				
			}
		} catch (ClientProtocolException e) {
			Log.e("test", "There was a protocol based error", e);
		} catch (IOException e) {
			Log.e("test", "There was an IO Stream related error", e);
		}
		return null;
	}

	// SAX-Parser
	// @Override
	// protected String doInBackground(String... uri) {
	// try {
	// // Create a URL we want to load some xml-data from.
	// URL url = new URL(uri[0]);
	//
	// // Get a SAXParser from the SAXPArserFactory.
	// SAXParserFactory spf = SAXParserFactory.newInstance();
	// SAXParser sp = spf.newSAXParser();
	//
	// // Get the XMLReader of the SAXParser we created.
	// XMLReader xr = sp.getXMLReader();
	// // Create a new ContentHandler and apply it to the XML-Reader
	// XmlHandler myXmlHandler = new XmlHandler();
	// xr.setContentHandler(myXmlHandler);
	//
	// // Parse the xml-data from our URL.
	// xr.parse(new InputSource(url.openStream()));
	// // Parsing has finished.
	//
	// // Our ExampleHandler now provides the parsed data to us.
	// Vector<User> users = myXmlHandler.getUserData();
	//
	// String result = "";
	// for (int i = 0; i < users.size(); i++) {
	// result = result + "ID: " + users.get(i).getId() + ", Name: "
	// + users.get(i).getName() + ", Key: "
	// + users.get(i).getKey() + "\n";
	// }
	// return result;
	// } catch (Exception e) {
	// Log.e("test", "Some error", e);
	// }
	// return null;
	// }

	protected void onProgressUpdate(Integer... progress) {
		// give progress updates to the UI
		// progress[0]
	}

	protected void onPostExecute(String result) {
		Log.d("test", result);

	}

}
